"use client";
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { checkSessionExpiry } from "@/utils/session";

export default function SessionWatcher() {
  const dispatch = useDispatch();
  const authState = useSelector((state) => state.auth);

  useEffect(() => {
    checkSessionExpiry(authState, dispatch);
  }, [authState, dispatch]);

  return null;
}
